%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   Equipotential lines for a small electric dipole


clear all;
close all;
EPS0 = 8.854e-12; 
p = 1*10^(-12); %Moment of electric dipole (C m)
[x,z]=meshgrid(0.1:0.001:0.6, -0.25:0.001:0.25);
% Radial distance 
r=sqrt(x.^2 + z.^2);
% Potential 
V=p*(z./r)./(4*pi*EPS0*r.^2);
figure (1);
pcolor(x,z,V);
xlabel('x (m)');
ylabel('z (m)');
title('Potential distribution of electric dipole in plane y=0');
shading interp;
colorbar;
figure(2);
contour(x,z,V,'linewidth',3);
xlabel('x (m)');
ylabel('z (m)');
title('Equipotential lines');
